<?php
/**
 * LegacyDependencyContainer.php 2020-06-10
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

declare(strict_types=1);

use Gambio\Admin\Application\Http\AdminHttpServiceProvider;
use Gambio\Admin\Application\Kernel\Bootstrapper\LoadAdminShopConfiguration;
use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\Server;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Configuration\ConfigurationServiceProvider;
use Gambio\Admin\Layout\Menu\AdminMenuServiceProvider;
use Gambio\Admin\ParcelService\ParcelServiceServiceProvider;
use Gambio\Admin\TrackingCode\TrackingCodeServiceProvider;
use Gambio\Admin\Withdrawal\WithdrawalServiceProvider;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\Bootstrapper\LoadUserPreferencesFromSession;
use Gambio\Core\Application\Plugins\PluginsServiceProvider;
use Gambio\Core\Application\ServiceProviders\CiDbServiceProvider;
use Gambio\Core\Application\ServiceProviders\DoctrineQbServiceProvider;
use Gambio\Core\Auth\AuthenticationServiceProvider;
use Gambio\Core\Cache\CacheServiceProvider;
use Gambio\Core\Command\CommandDispatcherServiceProvider;
use Gambio\Core\Event\EventDispatcherServiceProvider;
use Gambio\Core\Filesystem\FilesystemServiceProvider;
use Gambio\Core\Images\ImagesServiceProvider;
use Gambio\Core\Language\LanguageServiceProvider;
use Gambio\Core\Language\TextPhrasesServiceProvider;
use Gambio\Core\Logging\LoggingServiceProvider;
use Gambio\Core\Permission\PermissionServiceProvider;
use Gambio\Shop\Product\Description\ServiceProvider as ProductDescriptionServiceProvider;
use Gambio\Shop\Product\Name\ServiceProvider as ProductNameServiceProvider;
use Gambio\Shop\Product\SellingUnitImage\Database\ServiceProvider;
use Gambio\Shop\Product\Url\ServiceProvider as ProductUrlServiceProvider;
use Gambio\Shop\SellingUnit\Database\Unit\SellingUnitServiceProvider;
use Gambio\Shop\SellingUnit\Database\Price\ProductInformation\ServiceProvider as PriceProductInformationServiceProvider;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\ServiceProvider as PricePropertyInformationServiceProvider;
use Gambio\Shop\SellingUnit\Database\Price\AttributeInformation\ServiceProvider as PriceAttributeInformationServiceProvider;
use Gambio\Shop\Product\Tabs\ServiceProvider as ProductTabsServiceProvider;
use Gambio\Shop\Product\NumberOfOrders\ServiceProvider as ProductNumberOfOrdersServiceProvider;
use Gambio\Shop\Product\LegalAgeFlag\ServiceProvider as ProductLegalAgeFlagServiceProvider;
use Gambio\Shop\Product\AvailabilityDate\ServiceProvider as ProductAvailabilityDateServiceProvider;
use Gambio\Shop\Product\ReleaseDate\ServiceProvider as ProductReleaseDateServiceProvider;
use Gambio\Shop\Product\Status\ServiceProvider as ProductStatusServiceProvider;
use Gambio\Shop\Product\Ean\ServiceProvider as ProductEanServiceProvider;
use Gambio\Shop\Attributes\SellingUnitEan\ServiceProvider as SellingUnitEanAttributesServiceProvider;
use Gambio\Shop\Properties\SellingUnitEan\ServiceProvider as SellingUnitEanPropertiesServiceProvider;

/**
 * Class EventDispatcher
 */
class LegacyDependencyContainer
{
    /**
     * @var Application
     */
    private static $container;
    
    
    /**
     * @return Application
     */
    public static function getInstance(): Application
    {
        if (!self::$container instanceof Application) {
            if (!class_exists(Application::class)) {
                require_once __DIR__ . '/../../vendor/autoload.php';
            }
    
            self::$container   = new Application();
    
            if (defined('UNIT_TEST_RUNNING')) {
                $serverPath = '/var/www/html';
                $host       = 'www.mein-test-shop.de';
                $webPath    = '';
                $sslEnabled = true;
                $requestUri = 'www.mein-test-shop.de';
        
                self::$container->share(Path::class)->addArgument($serverPath);
                self::$container->share(Url::class)->addArguments([$host, $webPath]);
                self::$container->share(Server::class)->addArguments([$sslEnabled, $requestUri]);
            } else {
                $host       = HTTP_SERVER;
                $webPath    = rtrim(DIR_WS_CATALOG, '/');
                $serverPath = rtrim(DIR_FS_CATALOG, '/');

                $isSslEnabled = false;
                if (defined('ENABLE_SSL')) {
                    $isSslEnabled = ENABLE_SSL === true;
                } elseif (defined('ENABLE_SSL_CATALOG')) {
                    $isSslEnabled = strtolower(ENABLE_SSL_CATALOG) === 'true';
                }
                
                $requestUri = $_SERVER['REQUEST_URI'];

                self::$container->share(Path::class)->addArgument($serverPath);
                self::$container->share(Url::class)->addArguments([$host, $webPath]);
                self::$container->share(Server::class)->addArguments([$isSslEnabled, $requestUri]);
            }
    
            self::$container->addServiceProvider((new LoggingServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new AdminHttpServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new TextPhrasesServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new CacheServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new EventDispatcherServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new CommandDispatcherServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new FilesystemServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new ImagesServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new AuthenticationServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new ConfigurationServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new ParcelServiceServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new TrackingCodeServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new AdminMenuServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new LanguageServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new WithdrawalServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new PermissionServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider((new PluginsServiceProvider(self::$container))->toLeagueInterface());
            
            self::$container->addServiceProvider((new DoctrineQbServiceProvider(self::$container))->toLeagueInterface());
            self::$container->addServiceProvider(CiDbServiceProvider::class);
            
            self::$container->addServiceProvider(ServiceProvider::class);
            
            /**
             * @internal Do not change the order for OnCreateSellingUnitEvent listeners
             */
            self::$container->addServiceProvider(\Gambio\Shop\Price\Product\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\Product\Database\ServiceProvider::class);
            self::$container->addServiceProvider(SellingUnitServiceProvider::class);
            
            /**
             * @internal Do not change the order of the following 3 PriceInformationServiceProviders
             */
            self::$container->addServiceProvider(PriceProductInformationServiceProvider::class);
            self::$container->addServiceProvider(PricePropertyInformationServiceProvider::class);
            self::$container->addServiceProvider(PriceAttributeInformationServiceProvider::class);
            
            self::$container->addServiceProvider(ProductNameServiceProvider::class);
            self::$container->addServiceProvider(ProductUrlServiceProvider::class);
            self::$container->addServiceProvider(ProductTabsServiceProvider::class);
            self::$container->addServiceProvider(ProductNumberOfOrdersServiceProvider::class);
            self::$container->addServiceProvider(ProductDescriptionServiceProvider::class);
            self::$container->addServiceProvider(ProductLegalAgeFlagServiceProvider::class);
            self::$container->addServiceProvider(ProductAvailabilityDateServiceProvider::class);
            self::$container->addServiceProvider(ProductReleaseDateServiceProvider::class);
            self::$container->addServiceProvider(ProductStatusServiceProvider::class);
            self::$container->addServiceProvider(ProductEanServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\SellingUnitImages\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Attributes\SellingUnitImages\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Attributes\ProductModifiers\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\ProductModifiers\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Stock\SellingUnitQuantity\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\SellingUnitQuantitiy\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\SellingUnitQuantitiy\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\SellingUnit\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\SellingUnit\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\SellingUnit\Unit\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Attributes\SellingUnit\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\Model\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\SellingUnitModel\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Attributes\SellingUnitModel\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\Weight\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\SellingUnitWeight\Database\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Attributes\SellingUnitWeight\Database\ServiceProvider::class);
            // DO NOT CHANGE: EAN-Attributes/Properties providers' order unless you want attributes to override properties
            self::$container->addServiceProvider(SellingUnitEanAttributesServiceProvider::class);
            self::$container->addServiceProvider(SellingUnitEanPropertiesServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\ShippingLink\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\TaxInfo\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\SellingUnit\Presentation\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Attributes\Representation\Id\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\Representation\Id\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\Representation\ProductLink\ServiceProvider::class);
            self::$container->addServiceProvider(Gambio\Shop\Attributes\Representation\SelectionHtml\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\Representation\SelectionHtml\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\Representation\ShortDescription\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Product\SellingUnitVpe\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Properties\SellingUnitVpe\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\Stock\SellingUnitStock\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\SellingUnit\Database\Image\ServiceProvider::class);
            self::$container->addServiceProvider(\Gambio\Shop\GxCustomizer\Representation\Id\ServiceProvider::class);
    
            if (!defined('UNIT_TEST_RUNNING')) {
                // LoadSessionData have to be booted after the configuration repository was registered
                $loadSessionData = new LoadUserPreferencesFromSession();
                $loadSessionData->boot(self::$container);
            }
        }
        
        return self::$container;
    }
}
